/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.facade;

import com.bxm.localnews.merchant.dto.MerchantManageOrderInfoDTO;
import com.bxm.localnews.merchant.entity.GroupOrderInfoFacadeVO;
import com.bxm.localnews.merchant.facade.fallback.MarketFallbackFactory;
import com.bxm.localnews.merchant.param.MerchantH5OrderParam;
import com.bxm.localnews.merchant.param.MerchantManageOrderParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.apache.ibatis.annotations.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author jieliGG
 * @date 2020/9/2 23:15
 **/
@FeignClient(value = "localnews-market", fallbackFactory = MarketFallbackFactory.class, primary = false)
public interface MarketFeignService {

    @GetMapping("/facade/order/getDetailByOrderNo")
    ResponseEntity<GroupOrderInfoFacadeVO> getDetailByOrderNo(@RequestParam("orderNo") String orderNo);


    @ApiOperation("10-61-02 根据订单号同意/拒绝退单")
    @GetMapping("/facade/order/operatorOrder")
    ResponseEntity<Message> operatorOrder(@RequestParam("orderNo") String orderNo, @RequestParam("result") Integer result);

    @ApiOperation("10-61-03 根据核销码核销订单")
    @GetMapping("/facade/order/verificationOrder")
    ResponseEntity<Integer> verificationOrder(@RequestParam("verificationCode") Long verificationCode,
                                              @RequestParam("merchantId") Long merchantId,
                                              @RequestParam("currentUserId") Long currentUserId);


    @ApiOperation("10-61-04 根据订单id获取订单信息")
    @GetMapping("/facade/order/getSomeInfoById")
    ResponseEntity<GroupOrderInfoFacadeVO> getSomeInfoById(@RequestParam("orderId") Long orderId);

    @ApiOperation("10-61-07 用户是否存在指定商品的团购订单")
    @GetMapping("/facade/order/hasUserOrder")
    ResponseEntity<Integer> hasUserOrder(@RequestParam("goodsId") Long goodsId, @RequestParam("userId") Long userId);

    @ApiOperation("10-61-08 根据商家id查询团购订单列表")
    @GetMapping("/facade/order/merchantOrderList")
    ResponseEntity<PageWarper<GroupOrderInfoFacadeVO>> merchantOrderList(@RequestParam("pageNum") Integer pageNum,
                                                                         @RequestParam("pageSize") Integer pageSize,
                                                                         @RequestParam("merchantId") Long merchantId,
                                                                         @RequestParam("state") Integer state);


    @ApiOperation("10-61-09 根据商家id查询团购订单列表-运营后台用")
    @GetMapping("/facade/order/getManagePageListOrder")
    ResponseEntity<PageWarper<GroupOrderInfoFacadeVO>> getManagePageListOrder(@RequestParam("orderNo") String orderNo,
                                                                              @RequestParam("goodsName") String goodsName,
                                                                              @RequestParam("merchantName") String merchantName,
                                                                              @RequestParam("goodsId") String goodsId,
                                                                              @RequestParam("phone") String phone,
                                                                              @RequestParam("state") Integer state,
                                                                              @RequestParam("expressStatus") Byte expressStatus,
                                                                              @RequestParam("pageNum") Integer pageNum,
                                                                              @RequestParam("pageSize") Integer pageSize);


    @ApiOperation("10-61-11 订单发货")
    @GetMapping("/facade/order/deliverOrder")
    ResponseEntity<Message> deliverOrder(@RequestParam("orderSn") String orderSn,
                                         @RequestParam("expressNum") String expressNum,
                                         @RequestParam("expressCompany") String expressCompany,
                                         @RequestParam("currentUserId") Long currentUserId);
}