package com.bxm.localnews.merchant.facade;

import com.bxm.localnews.merchant.dto.WithdrawAccountVO;
import com.bxm.localnews.merchant.facade.fallback.PaymentFallbackFactory;
import com.bxm.localnews.merchant.param.MerchantWithdrawFacadeParam;
import com.bxm.newidea.component.vo.Message;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author pf.w
 * @date 2020/8/31 16:07
 **/
@FeignClient(value = "localnews", fallbackFactory = PaymentFallbackFactory.class, primary = false)
public interface PaymentAccountService {
    /**
     * 获取用户绑定的支付相关信息
     *
     * @param type   1：支付宝账户相关  目前就一个
     * @param userId 用户ID
     * @return
     */
    @GetMapping("facade/withdraw/payment/paymentAccount")
    ResponseEntity<WithdrawAccountVO> paymentAccount(@RequestParam("type") Byte type, @RequestParam("userId") Long userId);

    /**
     * 6-91-04 商户提现
     * 根据请求的账号信息，直接给对应的支付宝账号 or 微信账号打款
     *
     * @param param param
     * @return 提现结果信息
     */
    @PostMapping("facade/withdraw/payment/merchantWithdraw")
    ResponseEntity<Message> merchantWithdraw(@RequestBody MerchantWithdrawFacadeParam param);
}
