package com.bxm.localnews.merchant.facade;

import com.bxm.localnews.merchant.facade.fallback.UserAccountFallbackFactory;
import com.bxm.localnews.merchant.param.AccountGoldParam;
import com.bxm.localnews.merchant.param.CashAccountParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "localnews-user", fallbackFactory = UserAccountFallbackFactory.class, primary = false)
public interface UserAccountFeignService {

    @ApiOperation(value = "9-96-05 现金账户处理", notes = "现金账户处理", httpMethod = "POST")
    @PostMapping("facade/account/cash/operation")
    ResponseEntity cashAccountOperation(@RequestBody CashAccountParam param);

    @PostMapping("facade/user/account/addGold")
    ResponseEntity<Boolean> addGold(@RequestBody AccountGoldParam param);

}