package com.bxm.localnews.merchant.facade.fallback;

import com.bxm.localnews.merchant.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.merchant.dto.ShareContentDTO;
import com.bxm.localnews.merchant.dto.TopicFacadeVO;
import com.bxm.localnews.merchant.facade.ForumPostFeignService;
import com.bxm.localnews.merchant.vo.ForumBasicVo;
import com.bxm.localnews.merchant.vo.ForumPostVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@Slf4j
public class ForumPostFallbackFactory implements FallbackFactory<ForumPostFeignService> {
    @Override
    public ForumPostFeignService create(Throwable throwable) {
        return new ForumPostFeignService() {

            @Override
            public ResponseEntity<TopicFacadeVO> getTopicById(Long id) {
                return ResponseEntity.ok(TopicFacadeVO.builder().build());
            }

            @Override
            public ResponseEntity<ForumPostBriefInfoDto> getPostWithoutDetail(Long postId) {
                return ResponseEntity.ok(ForumPostBriefInfoDto.builder().build());
            }

            @Override
            public ResponseEntity<ForumPostVo> getForumPostById(Long id) {
                return ResponseEntity.ok(new ForumPostVo());
            }

            @Override
            public ResponseEntity<List<ShareContentDTO>> getTopPost(String areaCode) {
                return ResponseEntity.ok(new ArrayList<>());
            }

            @Override
            public Boolean createPost(ForumBasicVo forumBasicVo) {
                return Boolean.FALSE;
            }

            @Override
            public ResponseEntity<TopicFacadeVO> getTopicByForumId(Long forumId) {
                return ResponseEntity.ok(TopicFacadeVO.builder().build());
            }
        };
    }
}
