package com.bxm.localnews.merchant.facade.fallback;

import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.facade.LocationFeignService;
import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author pf.w
 * @date 2020/7/13 20:07
 */
@Component
public class LocationFallbackFactory implements FallbackFactory<LocationFeignService> {

    @Override
    public LocationFeignService create(Throwable throwable) {
        return new LocationFeignService() {
            @Override
            public ResponseEntity<LocationDTO> getLocationByGeocode(String code) {
                return ResponseEntity.ok(new LocationDTO());
            }
        };
    }
}
