package com.bxm.localnews.merchant.facade.fallback;

import com.bxm.localnews.merchant.entity.GroupOrderInfoFacadeVO;
import com.bxm.localnews.merchant.facade.MarketFeignService;
import com.bxm.localnews.merchant.param.MerchantH5OrderParam;
import com.bxm.localnews.merchant.param.MerchantManageOrderParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@Slf4j
public class MarketFallbackFactory implements FallbackFactory<MarketFeignService> {
    @Override
    public MarketFeignService create(Throwable throwable) {
        return new MarketFeignService() {
            @Override
            public ResponseEntity<GroupOrderInfoFacadeVO> getDetailByOrderNo(String orderNo) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Message> operatorOrder(String orderNo, Integer result) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Integer> verificationOrder(Long verificationCode, Long merchantId, Long currentUserId) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<GroupOrderInfoFacadeVO> getSomeInfoById(Long orderId) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Integer> hasUserOrder(Long goodsId, Long userId) {
                return ResponseEntity.ok(0);
            }

            @Override
            public ResponseEntity<PageWarper<GroupOrderInfoFacadeVO>> merchantOrderList(Integer pageNum, Integer pageSize, Long merchantId, Integer state) {
                return ResponseEntity.ok(new PageWarper<>());
            }

            @Override
            public ResponseEntity<PageWarper<GroupOrderInfoFacadeVO>> getManagePageListOrder(String orderNo, String goodsName, String merchantName, String goodsId, String phone, Integer state, Byte expressStatus, Integer pageNum, Integer pageSize) {
                return null;
            }

            @Override
            public ResponseEntity<Message> deliverOrder(String orderNo, String expressNum, String expressCompany, Long currentUserId) {
                return null;
            }
        };
    }
}
