package com.bxm.localnews.merchant.facade.fallback;

import com.bxm.localnews.merchant.dto.WithdrawAccountVO;
import com.bxm.localnews.merchant.facade.PaymentAccountService;
import com.bxm.localnews.merchant.param.MerchantWithdrawFacadeParam;
import com.bxm.newidea.component.vo.Message;
import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author pf.w
 * @date 2020/8/31 16:10
 **/
@Component
public class PaymentFallbackFactory implements FallbackFactory<PaymentAccountService> {
    @Override
    public PaymentAccountService create(Throwable throwable) {
        return new PaymentAccountService() {
            @Override
            public ResponseEntity<WithdrawAccountVO> paymentAccount(Byte type, Long userId) {
                return ResponseEntity.ok(new WithdrawAccountVO());
            }

            @Override
            public ResponseEntity<Message> merchantWithdraw(MerchantWithdrawFacadeParam param) {
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
