package com.bxm.localnews.merchant.facade.fallback;

import com.bxm.localnews.merchant.dto.order.PaymentOrderDTO;
import com.bxm.localnews.merchant.facade.PaymentInfoFeignService;
import com.bxm.localnews.merchant.param.order.UserOrderParam;
import com.bxm.newidea.component.vo.ResponseJson;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * @Author: pf.w
 * @Date: 2020/7/14 10:18
 */
@Component
public class PaymentInfoFallbackFactory implements FallbackFactory<PaymentInfoFeignService> {
    @Override
    public PaymentInfoFeignService create(Throwable throwable) {
        return new PaymentInfoFeignService() {
            @Override
            public ResponseJson<PaymentOrderDTO> orderCreate(UserOrderParam param) {
                return ResponseJson.badReqeuset().build();
            }
        };
    }
}
