package com.bxm.localnews.merchant.facade.fallback;

import com.bxm.localnews.merchant.facade.UserAccountFeignService;
import com.bxm.localnews.merchant.param.AccountGoldParam;
import com.bxm.localnews.merchant.param.CashAccountParam;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class UserAccountFallbackFactory implements FallbackFactory<UserAccountFeignService> {

    @Override
    public UserAccountFeignService create(Throwable throwable) {
        return new UserAccountFeignService() {

            @Override
            public ResponseEntity<Boolean> addGold(AccountGoldParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity cashAccountOperation(CashAccountParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
