package com.bxm.localnews.merchant.integration;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.merchant.common.constant.MerchantGoodsEnum;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.web.util.UriUtils;

import javax.annotation.Resource;
import java.nio.charset.Charset;
import java.util.Objects;


public class AbstractPushService extends BaseService {

    @Resource
    protected DomainIntegrationService domainIntegrationService;

    @Resource
    protected MessageSender messageSender;


    protected void createMsg(Long userId, String title, String content, PushPayloadInfo info) {
        info.setTitle(title);
        info.setContent(content);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.DEFAULT_SOUND);
        message.assign(userId);
        messageSender.sendPushMessage(message);
    }

    protected PushMessage pushMerchantMember(Long userId, String url, String title, String content) {
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE);
        info.setProtocol(url);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);
        message.assign(userId);
        return message;
    }

    /**
     * @return 组装的客户端协议，老板用于跳转到全员营销页
     */
    protected String getBossAddress(MerchantInfo merchantInfo) {
        StringBuilder url = new StringBuilder();
        url.append(domainIntegrationService.getInnerH5BaseUrl())
                .append("/tk/marketing.html#/boss?merchantId=").append(merchantInfo.getId())
                .append("&userId=").append(merchantInfo.getUserId())
                .append("&areaCode={areaCode}")
                .append("&areaName={areaName}");
        return "wst://web/webDetail?url=" + UriUtils.encode(url.toString(), Charset.defaultCharset());

    }

    /**
     * 跳转到商家中心页面
     *
     * @param merchantInfo
     * @return
     */
    protected String getBossMerchantAddress(MerchantInfo merchantInfo) {
        StringBuilder url = new StringBuilder();
        url.append(domainIntegrationService.getInnerH5BaseUrl())
                .append("/tk/merchant.html#/shopCenter?merchantId=").append(merchantInfo.getId())
                .append("&userId=").append(merchantInfo.getUserId())
                .append("&areaCode={areaCode}")
                .append("&areaName={areaName}");
        return "wst://web/webDetail?url=" + UriUtils.encode(url.toString(), Charset.defaultCharset());
    }

    /**
     * @return 组装的客户端协议，老板用于跳转到商品管理-出售中页
     */
    protected String getGoodsBossAddress(MerchantInfo merchantInfo, MerchantGoodsEnum merchantGoodsEnum) {
        Integer type = null;
        if (Objects.equals(MerchantGoodsEnum.PAGE_GOODS_SALEIN, merchantGoodsEnum)) {
            type = MerchantGoodsEnum.PAGE_GOODS_SALEIN.getType();
        } else if (Objects.equals(MerchantGoodsEnum.PAGE_GOODS_AUDIT, merchantGoodsEnum)) {
            type = MerchantGoodsEnum.PAGE_GOODS_AUDIT.getType();
        } else if (Objects.equals(MerchantGoodsEnum.PAGE_GOODS_SALEOUT, merchantGoodsEnum)) {
            type = MerchantGoodsEnum.PAGE_GOODS_SALEOUT.getType();
        }

        StringBuilder url = new StringBuilder();
        url.append(domainIntegrationService.getInnerH5BaseUrl())
                .append("/tk/goods.html#/commodity?merchantId=").append(merchantInfo.getId())
                .append("&userId=").append(merchantInfo.getUserId())
                .append("&areaCode={areaCode}")
                .append("&areaName={areaName}").append("&type=").append(type);
        return "wst://web/webDetail?url=" + UriUtils.encode(url.toString(), Charset.defaultCharset());
    }

    /**
     * @return 组装的客户端协议，员工用于跳转到店铺管理（员工）
     */
    protected String getEmployeeAddressToCenter(Long merchantId, Long userId) {
        StringBuilder url = new StringBuilder();
        url.append(domainIntegrationService.getInnerH5BaseUrl())
                .append("/tk/merchant.html#/employeeCenter?merchantId=").append(merchantId)
                .append("&userId=").append(userId)
                .append("&areaCode={areaCode}")
                .append("&areaName={areaName}");
        return "wst://web/webDetail?url=" + UriUtils.encode(url.toString(), Charset.defaultCharset());
    }
    /**
     * @return 组装的客户端协议，员工用于跳转到我的营销页
     */
    protected String getEmployeeAddress(Long merchantId, Long userId) {
        StringBuilder url = new StringBuilder();
        url.append(domainIntegrationService.getInnerH5BaseUrl())
                .append("/tk/marketing.html#/staff?merchantId=").append(merchantId)
                .append("&userId=").append(userId)
                .append("&areaCode={areaCode}")
                .append("&areaName={areaName}");
        return "wst://web/webDetail?url=" + UriUtils.encode(url.toString(), Charset.defaultCharset());
    }
}
