package com.bxm.localnews.merchant.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.dto.TopicFacadeVO;
import com.bxm.localnews.merchant.facade.ForumPostFeignService;
import com.bxm.localnews.merchant.vo.ForumBasicVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/10/30 4:22 下午
 */
@Slf4j
@Service
public class ForumPostIntegrationService {
    @Resource
    private ForumPostFeignService forumPostFeignService;

    public Boolean createPost(ForumBasicVo forumBasicVo) {
        try {
            Boolean responseEntity = forumPostFeignService.createPost(forumBasicVo);
            if (Objects.nonNull(responseEntity)) {
                return responseEntity;
            }

        } catch (Exception e) {
            log.error("调用发帖失败, 请求参数: {} ", JSON.toJSONString(forumBasicVo), e);
        }
        return Boolean.FALSE;
    }

    public TopicFacadeVO getTopicInfoByForumId(Long forumId) {
        try {
            ResponseEntity<TopicFacadeVO> entity = forumPostFeignService.getTopicByForumId(forumId);
            if (entity.hasBody()) {
                return entity.getBody();
            }
        } catch (Exception e) {
            log.error("服务调用失败 ： {}", e);
        }
        return null;
    }
}