package com.bxm.localnews.merchant.integration;

import com.bxm.localnews.merchant.facade.ImFeignService;
import com.bxm.localnews.merchant.param.BatchMessageParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

import static com.alibaba.fastjson.JSON.toJSONString;

/**
 * @author wzy
 * @date 2020年10月29日21:03:38
 **/
@Slf4j
@Service
@AllArgsConstructor
public class ImIntegrationService {
    @Resource
    private ImFeignService imFeignService;

    /**
     * 发送私聊消息
     *
     * @param param 私聊消息内容
     */
    public void sendMsg(BatchMessageParam param) {
        try {
            imFeignService.batchMessage(param);
        } catch (Exception e) {
            log.error("发送消息失败, 请求参数: {}", toJSONString(param), e);
        }
    }

}
