/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.entity.GroupOrderInfoFacadeVO;
import com.bxm.localnews.merchant.facade.MarketFeignService;
import com.bxm.localnews.merchant.param.MerchantH5OrderParam;
import com.bxm.localnews.merchant.param.MerchantManageOrderParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Objects;

/**
 * @author jieliGG
 * @date 2020/9/2 23:15
 **/
@Slf4j
@Component
public class MarketIntegrationService {

    @Autowired
    private MarketFeignService marketFeignService;

    /***
     * 根据订单号获取详情
     * @param orderNo
     * @return
     */
    public GroupOrderInfoFacadeVO getDetailByOrderNo(@RequestParam("orderNo") String orderNo) {
        return marketFeignService.getDetailByOrderNo(orderNo).getBody();
    }

    /**
     * 审核退单信息
     *
     * @param orderNo ： 订单号
     * @param result  ： 0-拒绝 1-同意
     * @return
     */
    public Message operatorOrder(@RequestParam("orderNo") String orderNo, @RequestParam("result") Integer result) {
        return marketFeignService.operatorOrder(orderNo, result).getBody();
    }

    /**
     * 根据核销码核销订单
     *
     * @param verificationCode ： 核销码
     * @param merchantId       ： 商家id
     * @return ： 核销结果 1-成功核销 2-核销码错误 3-已经核销过了
     */
    public Integer verificationOrder(Long verificationCode, Long merchantId) {
        return verificationOrder(verificationCode, merchantId, null);
    }

    /**
     * 根据核销码核销订单
     *
     * @param verificationCode ： 核销码
     * @param merchantId       ： 商家id
     * @return ： 核销结果 1-成功核销 2-核销码错误 3-已经核销过了
     */
    public Integer verificationOrder(Long verificationCode, Long merchantId, Long currentUserId) {

        try {
            ResponseEntity<Integer> integerResponseEntity = marketFeignService.verificationOrder(verificationCode, merchantId, currentUserId);

            if (Objects.nonNull(integerResponseEntity) && integerResponseEntity.hasBody()) {
                return integerResponseEntity.getBody();
            }

        } catch (Exception e) {
            log.error("调用订单模块失败, verificationCode: {}, merchantId: {}, currentUserId: {}", verificationCode,
                    merchantId, currentUserId, e);
        }

        return 3;
    }


    /**
     * 根据核销码核销订单
     *
     * @param orderId : 订单id
     * @return ： 核销结果
     */
    public GroupOrderInfoFacadeVO getSomeInfoById(Long orderId) {
        try {
            ResponseEntity<GroupOrderInfoFacadeVO> orderEntity = marketFeignService.getSomeInfoById(orderId);
            if (null != orderEntity) {
                return orderEntity.getBody();
            }
        } catch (Exception e) {

        }
        return new GroupOrderInfoFacadeVO();
    }

    /**
     * 用户是否存在指定商品的团购订单
     *
     * @param goodsId 商品ID
     * @param userId  用户ID
     * @return 大于0表示存在订单
     */
    public int hasUserOrder(Long goodsId, Long userId) {
        try {
            ResponseEntity<Integer> orderEntity = marketFeignService.hasUserOrder(goodsId, userId);
            if (null != orderEntity) {
                return orderEntity.getBody();
            }
        } catch (Exception e) {
            log.error("调用market服务失败, goodsId : {}, userId: {}", goodsId, userId);
        }

        return 0;
    }

    /**
     * 根据商家id查询团购订单列表
     *
     * @param param param
     * @return 团购订单列表
     */
    public PageWarper<GroupOrderInfoFacadeVO> merchantOrderList(MerchantH5OrderParam param) {
        try {
            ResponseEntity<PageWarper<GroupOrderInfoFacadeVO>> pageWarperResponseEntity = marketFeignService.merchantOrderList(param.getPageNum(),
                    param.getPageSize(), param.getMerchantId(), param.getState());

            if (Objects.nonNull(pageWarperResponseEntity) && pageWarperResponseEntity.hasBody()) {
                return pageWarperResponseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("根据商家id查询团购订单列表失败, param: {}", JSON.toJSONString(param), e);
        }

        return new PageWarper();
    }


    /**
     * 根据商家id查询团购订单列表
     *
     * @param param param
     * @return 团购订单列表
     */
    public PageWarper<GroupOrderInfoFacadeVO> getManagePageListOrder(MerchantManageOrderParam param) {
        try {
            ResponseEntity<PageWarper<GroupOrderInfoFacadeVO>> pageWarperResponseEntity = marketFeignService.getManagePageListOrder(param.getOrderNo(),
                    param.getGoodsName(), param.getMerchantName(), param.getGoodsId(), param.getPhone(), param.getState(), param.getExpressStatus(),
                    param.getPageNum(), param.getPageSize());

            if (Objects.nonNull(pageWarperResponseEntity) && pageWarperResponseEntity.hasBody()) {
                return pageWarperResponseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("根据商家id查询团购订单列表-管理端, param: {}", JSON.toJSONString(param), e);
        }

        return new PageWarper();
    }

    /**
     * 发货
     *
     * @param orderNo        订单号
     * @param expressNum     物流编码
     * @param expressCompany 物流公司
     * @param currentUserId  操作人
     * @return 操作结果
     */
    public Message deliverOrder(String orderNo, String expressNum, String expressCompany, Long currentUserId) {
        try {
            ResponseEntity<Message> messageResponseEntity = marketFeignService.deliverOrder(orderNo, expressNum, expressCompany, currentUserId);
            if (Objects.nonNull(messageResponseEntity) && messageResponseEntity.hasBody()) {
                return messageResponseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("发货失败 orderNo: {}, expressNum: {}, expressCompany: {}, currentUserId: {} ", orderNo, expressNum, expressCompany, currentUserId, e);
        }

        return Message.build(false, "请求失败");
    }
}
