package com.bxm.localnews.merchant.integration;

import com.bxm.localnews.merchant.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.merchant.dto.NewsBriefInfoDto;
import com.bxm.localnews.merchant.dto.TopicFacadeVO;
import com.bxm.localnews.merchant.facade.ForumPostFeignService;
import com.bxm.localnews.merchant.facade.NewsFacadeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * 新闻服务集成服务接口
 *
 * @author liujia
 * @date 2020/05/12 10:55
 */
@Component
public class NewsIntegrationService {
    private final ForumPostFeignService forumPostFeignService;

    private final NewsFacadeService newsFacadeService;

    @Autowired
    public NewsIntegrationService(ForumPostFeignService forumPostFeignService,
                                  NewsFacadeService newsFacadeService) {
        this.forumPostFeignService = forumPostFeignService;
        this.newsFacadeService = newsFacadeService;
    }

    public ForumPostBriefInfoDto getPostWithoutDetail(Long postId) {
        ResponseEntity<ForumPostBriefInfoDto> postWithoutDetail = forumPostFeignService.getPostWithoutDetail(postId);
        if (postWithoutDetail.hasBody()) {
            return postWithoutDetail.getBody();
        }
        return ForumPostBriefInfoDto.builder().id(postId).build();
    }

    public NewsBriefInfoDto getNewsInfo(Long newsId) {
        ResponseEntity<NewsBriefInfoDto> newsInfo = newsFacadeService.getBriefInfo(newsId, null, null);
        if (newsInfo.hasBody()) {
            return newsInfo.getBody();
        }
        return NewsBriefInfoDto.builder().id(newsId).build();
    }

    public TopicFacadeVO getTopicById(Long topicId) {
        ResponseEntity<TopicFacadeVO> topic = forumPostFeignService.getTopicById(topicId);
        if (topic.hasBody()) {
            return topic.getBody();
        }
        return TopicFacadeVO.builder().id(topicId).build();
    }
}
