package com.bxm.localnews.merchant.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.dto.WithdrawAccountVO;
import com.bxm.localnews.merchant.dto.order.PaymentOrderDTO;
import com.bxm.localnews.merchant.facade.PaymentAccountService;
import com.bxm.localnews.merchant.facade.PaymentInfoFeignService;
import com.bxm.localnews.merchant.param.MerchantWithdrawFacadeParam;
import com.bxm.localnews.merchant.param.order.UserOrderParam;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author pf.w
 * @date 2020/8/31 16:14
 **/
@Slf4j
@Service
public class PaymentIntegrationService {

    @Resource
    private PaymentAccountService paymentAccountService;

    @Resource
    private PaymentInfoFeignService paymentInfoFeignService;

    /**
     * 获取绑定的支付宝信息
     *
     * @param userId
     * @return
     */
    public WithdrawAccountVO getPaymentAccount(Long userId) {
        try {
            ResponseEntity<WithdrawAccountVO> responseEntity = paymentAccountService.paymentAccount((byte) 1, userId);
            if (Objects.nonNull(responseEntity) && Objects.nonNull(responseEntity.getBody())) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("获取绑定的支付宝信息失败 userId: {} ", userId, e);
        }
        return null;
    }


    /**
     * 调用支付模块打款
     *
     * @param param 提现参数
     * @return 提现结果
     */
    public Message merchantWithdraw(MerchantWithdrawFacadeParam param) {
        try {
            ResponseEntity<Message> messageResponseEntity = paymentAccountService.merchantWithdraw(param);
            if (Objects.nonNull(messageResponseEntity) && Objects.nonNull(messageResponseEntity.getBody())) {
                return messageResponseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("调用第三方打款失败, 请求参数: {} ", JSON.toJSONString(param), e);
        }

        return Message.build(false, "调用第三方打款失败");
    }

    /**
     * 创建订单
     *
     * @param param
     * @return
     */
    public PaymentOrderDTO orderCreate(UserOrderParam param) {
        return paymentInfoFeignService.orderCreate(param).getResult();
    }


}
