package com.bxm.localnews.merchant.integration;

import com.bxm.localnews.merchant.facade.UserAccountFeignService;
import com.bxm.localnews.merchant.param.AccountGoldParam;
import com.bxm.localnews.merchant.param.CashAccountParam;
import com.bxm.localnews.user.enums.GoldEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class UserAccountIntegrationService {

    @Resource
    private UserAccountFeignService userAccountFeignService;

    /**
     * 用户现金处理参数
     *
     * @param param 处理参数
     */
    public boolean cashAccountOperation(CashAccountParam param) {
        ResponseEntity responseEntity = userAccountFeignService.cashAccountOperation(param);

        return HttpStatus.OK.equals(responseEntity.getStatusCode());
    }

    public Boolean addGold(AccountGoldParam param) {
        ResponseEntity<Boolean> responseEntity = userAccountFeignService.addGold(param);
        if (responseEntity.hasBody()) {
            return responseEntity.getBody();
        }

        return false;
    }

    /**
     * 扣除金币用于参加夺宝活动
     *
     * @param userId       扣除的目标用户
     * @param goldNum      扣除金币数量
     * @param phaseId      参与活动期数ID
     * @param lotteryTitle 参与活动标题
     * @return 扣除结果，true表示扣除成功
     */
    public boolean deductGoldWithLottery(Long userId, Integer goldNum, Long phaseId, String lotteryTitle) {
        AccountGoldParam param = new AccountGoldParam();
        param.setUserId(userId);
        param.setGold(goldNum);
        param.setGoldType(GoldEnum.CONSUME_GOLD.name());
        param.setGoldFlowType(GoldFlowTypeEnum.OTHER.name());
        param.setAddTotal(false);
        param.setRelationId(phaseId);
        param.setReason("参与《" + lotteryTitle + "》");
        param.setContent("参与《" + lotteryTitle + "》");

        return addGold(param);
    }
}