/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.facade;

import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.UserInviteHistoryDTO;
import com.bxm.localnews.merchant.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.merchant.param.UserFollowTypeParam;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="localnews-user", fallbackFactory=UserFallbackFactory.class, primary=false)
public interface UserFeignService {
    @GetMapping(value={"/facade/user/info"})
    public ResponseEntity<UserInfoDTO> getUserFromCache(@RequestParam(value="userId") Long var1);

    @PostMapping(value={"/facade/user/getVirtualUserList"})
    public ResponseEntity<List<UserInfoDTO>> getVirtualUserList(@RequestParam(value="num") Integer var1);

    @GetMapping(value={"/facade/user/invite/getInviteHistoryListByUid"})
    public ResponseEntity<List<UserInviteHistoryDTO>> getInviteHistoryListByUid(@RequestParam(value="userId") Long var1);

    @PostMapping(value={"/facade/user/follow"})
    public ResponseEntity<Boolean> follow(@RequestBody UserFollowTypeParam var1);

    @GetMapping(value={"facade/user/isVip"})
    public ResponseEntity<Boolean> checkUserIsVip(@RequestParam(value="userId") Long var1);

    @ApiOperation(value="9-88-01 \u5224\u65ad\u7528\u6237\u662f\u5426\u5173\u6ce8\u4e86\u5bf9\u65b9")
    @GetMapping(value={"facade/user/isFollow"})
    public ResponseEntity<Boolean> isFollow(@RequestParam(value="fromUserId") Long var1, @RequestParam(value="toUserId") Long var2);

    @GetMapping(value={"facade/user/updateUserJudgeMarker"})
    public ResponseEntity<Boolean> updateUserJudgeMarker(@RequestParam(value="userId") Long var1, @RequestParam(value="judgeMarker") LocalNewsUserJudgeMarkerEnum var2, @RequestParam(value="add") Boolean var3);
}

