/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.dto.TopicFacadeVO;
import com.bxm.localnews.merchant.facade.ForumPostFeignService;
import com.bxm.localnews.merchant.vo.ForumBasicVo;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ForumPostIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(ForumPostIntegrationService.class);
    @Resource
    private ForumPostFeignService forumPostFeignService;

    public Boolean createPost(ForumBasicVo forumBasicVo) {
        try {
            Boolean responseEntity = this.forumPostFeignService.createPost(forumBasicVo);
            if (Objects.nonNull(responseEntity)) {
                return responseEntity;
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u53d1\u5e16\u5931\u8d25, \u8bf7\u6c42\u53c2\u6570: {} ", (Object)JSON.toJSONString((Object)forumBasicVo), (Object)e);
        }
        return Boolean.FALSE;
    }

    public TopicFacadeVO getTopicInfoByForumId(Long forumId) {
        try {
            ResponseEntity<TopicFacadeVO> entity = this.forumPostFeignService.getTopicByForumId(forumId);
            if (entity.hasBody()) {
                return (TopicFacadeVO)entity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u8c03\u7528\u5931\u8d25 \uff1a {}", (Throwable)e);
        }
        return null;
    }
}

