/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.integration;

import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.facade.LocationFeignService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class LocationIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(LocationIntegrationService.class);
    @Resource
    private LocationFeignService locationFeignService;
    private LoadingCache<String, LocationDTO> cache;

    public LocationDTO getLocationByGeocode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return new LocationDTO();
        }
        if (this.cache == null) {
            this.initCache();
        }
        return (LocationDTO)this.cache.getUnchecked((Object)code);
    }

    private void initCache() {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(1000L).build((CacheLoader)new CacheLoader<String, LocationDTO>(){

            public LocationDTO load(String key) {
                LocationDTO body = null;
                try {
                    ResponseEntity<LocationDTO> responseEntity = LocationIntegrationService.this.locationFeignService.getLocationByGeocode(key);
                    if (Objects.nonNull(responseEntity)) {
                        body = (LocationDTO)responseEntity.getBody();
                    }
                }
                catch (Exception e) {
                    log.error("\u8bf7\u6c42biz\u670d\u52a1\u83b7\u53d6\u57ce\u5e02\u4fe1\u606f\u5931\u8d25, key: {} ", (Object)key, (Object)e);
                }
                if (body == null) {
                    body = new LocationDTO();
                    body.setCode(key);
                }
                return body;
            }
        });
    }
}

