/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.entity.GroupOrderInfoFacadeVO;
import com.bxm.localnews.merchant.facade.MarketFeignService;
import com.bxm.localnews.merchant.param.MerchantH5OrderParam;
import com.bxm.localnews.merchant.param.MerchantManageOrderParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

@Component
public class MarketIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(MarketIntegrationService.class);
    @Autowired
    private MarketFeignService marketFeignService;

    public GroupOrderInfoFacadeVO getDetailByOrderNo(@RequestParam(value="orderNo") String orderNo) {
        return (GroupOrderInfoFacadeVO)this.marketFeignService.getDetailByOrderNo(orderNo).getBody();
    }

    public Message operatorOrder(@RequestParam(value="orderNo") String orderNo, @RequestParam(value="result") Integer result) {
        return (Message)this.marketFeignService.operatorOrder(orderNo, result).getBody();
    }

    public Integer verificationOrder(Long verificationCode, Long merchantId) {
        return this.verificationOrder(verificationCode, merchantId, null);
    }

    public Integer verificationOrder(Long verificationCode, Long merchantId, Long currentUserId) {
        try {
            ResponseEntity<Integer> integerResponseEntity = this.marketFeignService.verificationOrder(verificationCode, merchantId, currentUserId);
            if (Objects.nonNull(integerResponseEntity) && integerResponseEntity.hasBody()) {
                return (Integer)integerResponseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u8ba2\u5355\u6a21\u5757\u5931\u8d25, verificationCode: {}, merchantId: {}, currentUserId: {}", new Object[]{verificationCode, merchantId, currentUserId, e});
        }
        return 3;
    }

    public GroupOrderInfoFacadeVO getSomeInfoById(Long orderId) {
        try {
            ResponseEntity<GroupOrderInfoFacadeVO> orderEntity = this.marketFeignService.getSomeInfoById(orderId);
            if (null != orderEntity) {
                return (GroupOrderInfoFacadeVO)orderEntity.getBody();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new GroupOrderInfoFacadeVO();
    }

    public int hasUserOrder(Long goodsId, Long userId) {
        try {
            ResponseEntity<Integer> orderEntity = this.marketFeignService.hasUserOrder(goodsId, userId);
            if (null != orderEntity) {
                return (Integer)orderEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528market\u670d\u52a1\u5931\u8d25, goodsId : {}, userId: {}", (Object)goodsId, (Object)userId);
        }
        return 0;
    }

    public PageWarper<GroupOrderInfoFacadeVO> merchantOrderList(MerchantH5OrderParam param) {
        try {
            ResponseEntity<PageWarper<GroupOrderInfoFacadeVO>> pageWarperResponseEntity = this.marketFeignService.merchantOrderList(param.getPageNum(), param.getPageSize(), param.getMerchantId(), param.getState());
            if (Objects.nonNull(pageWarperResponseEntity) && pageWarperResponseEntity.hasBody()) {
                return (PageWarper)pageWarperResponseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u5546\u5bb6id\u67e5\u8be2\u56e2\u8d2d\u8ba2\u5355\u5217\u8868\u5931\u8d25, param: {}", (Object)JSON.toJSONString((Object)param), (Object)e);
        }
        return new PageWarper();
    }

    public PageWarper<GroupOrderInfoFacadeVO> getManagePageListOrder(MerchantManageOrderParam param) {
        try {
            ResponseEntity<PageWarper<GroupOrderInfoFacadeVO>> pageWarperResponseEntity = this.marketFeignService.getManagePageListOrder(param.getOrderNo(), param.getGoodsName(), param.getMerchantName(), param.getGoodsId(), param.getPhone(), param.getState(), param.getExpressStatus(), param.getPageNum(), param.getPageSize());
            if (Objects.nonNull(pageWarperResponseEntity) && pageWarperResponseEntity.hasBody()) {
                return (PageWarper)pageWarperResponseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u5546\u5bb6id\u67e5\u8be2\u56e2\u8d2d\u8ba2\u5355\u5217\u8868-\u7ba1\u7406\u7aef, param: {}", (Object)JSON.toJSONString((Object)param), (Object)e);
        }
        return new PageWarper();
    }

    public Message deliverOrder(String orderNo, String expressNum, String expressCompany, Long currentUserId) {
        try {
            ResponseEntity<Message> messageResponseEntity = this.marketFeignService.deliverOrder(orderNo, expressNum, expressCompany, currentUserId);
            if (Objects.nonNull(messageResponseEntity) && messageResponseEntity.hasBody()) {
                return (Message)messageResponseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u8d27\u5931\u8d25 orderNo: {}, expressNum: {}, expressCompany: {}, currentUserId: {} ", new Object[]{orderNo, expressNum, expressCompany, currentUserId, e});
        }
        return Message.build((boolean)false, (String)"\u8bf7\u6c42\u5931\u8d25");
    }
}

