/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.integration;

import com.bxm.localnews.merchant.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.merchant.dto.NewsBriefInfoDto;
import com.bxm.localnews.merchant.dto.TopicFacadeVO;
import com.bxm.localnews.merchant.facade.ForumPostFeignService;
import com.bxm.localnews.merchant.facade.NewsFacadeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class NewsIntegrationService {
    private final ForumPostFeignService forumPostFeignService;
    private final NewsFacadeService newsFacadeService;

    @Autowired
    public NewsIntegrationService(ForumPostFeignService forumPostFeignService, NewsFacadeService newsFacadeService) {
        this.forumPostFeignService = forumPostFeignService;
        this.newsFacadeService = newsFacadeService;
    }

    public ForumPostBriefInfoDto getPostWithoutDetail(Long postId) {
        ResponseEntity<ForumPostBriefInfoDto> postWithoutDetail = this.forumPostFeignService.getPostWithoutDetail(postId);
        if (postWithoutDetail.hasBody()) {
            return (ForumPostBriefInfoDto)postWithoutDetail.getBody();
        }
        return ForumPostBriefInfoDto.builder().id(postId).build();
    }

    public NewsBriefInfoDto getNewsInfo(Long newsId) {
        ResponseEntity<NewsBriefInfoDto> newsInfo = this.newsFacadeService.getBriefInfo(newsId, null, null);
        if (newsInfo.hasBody()) {
            return (NewsBriefInfoDto)newsInfo.getBody();
        }
        return NewsBriefInfoDto.builder().id(newsId).build();
    }

    public TopicFacadeVO getTopicById(Long topicId) {
        ResponseEntity<TopicFacadeVO> topic = this.forumPostFeignService.getTopicById(topicId);
        if (topic.hasBody()) {
            return (TopicFacadeVO)topic.getBody();
        }
        return TopicFacadeVO.builder().id(topicId).build();
    }
}

