/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.dto.WithdrawAccountVO;
import com.bxm.localnews.merchant.dto.order.PaymentOrderDTO;
import com.bxm.localnews.merchant.facade.PaymentAccountService;
import com.bxm.localnews.merchant.facade.PaymentInfoFeignService;
import com.bxm.localnews.merchant.param.MerchantWithdrawFacadeParam;
import com.bxm.localnews.merchant.param.order.UserOrderParam;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class PaymentIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(PaymentIntegrationService.class);
    @Resource
    private PaymentAccountService paymentAccountService;
    @Resource
    private PaymentInfoFeignService paymentInfoFeignService;

    public WithdrawAccountVO getPaymentAccount(Long userId) {
        try {
            ResponseEntity<WithdrawAccountVO> responseEntity = this.paymentAccountService.paymentAccount((byte)1, userId);
            if (Objects.nonNull(responseEntity) && Objects.nonNull(responseEntity.getBody())) {
                return (WithdrawAccountVO)responseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ed1\u5b9a\u7684\u652f\u4ed8\u5b9d\u4fe1\u606f\u5931\u8d25 userId: {} ", (Object)userId, (Object)e);
        }
        return null;
    }

    public Message merchantWithdraw(MerchantWithdrawFacadeParam param) {
        try {
            ResponseEntity<Message> messageResponseEntity = this.paymentAccountService.merchantWithdraw(param);
            if (Objects.nonNull(messageResponseEntity) && Objects.nonNull(messageResponseEntity.getBody())) {
                return (Message)messageResponseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7b2c\u4e09\u65b9\u6253\u6b3e\u5931\u8d25, \u8bf7\u6c42\u53c2\u6570: {} ", (Object)JSON.toJSONString((Object)param), (Object)e);
        }
        return Message.build((boolean)false, (String)"\u8c03\u7528\u7b2c\u4e09\u65b9\u6253\u6b3e\u5931\u8d25");
    }

    public PaymentOrderDTO orderCreate(UserOrderParam param) {
        return (PaymentOrderDTO)this.paymentInfoFeignService.orderCreate(param).getResult();
    }
}

