/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.integration;

import com.bxm.localnews.merchant.facade.UserAccountFeignService;
import com.bxm.localnews.merchant.param.AccountGoldParam;
import com.bxm.localnews.merchant.param.CashAccountParam;
import com.bxm.localnews.user.enums.GoldEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import javax.annotation.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UserAccountIntegrationService {
    @Resource
    private UserAccountFeignService userAccountFeignService;

    public boolean cashAccountOperation(CashAccountParam param) {
        ResponseEntity responseEntity = this.userAccountFeignService.cashAccountOperation(param);
        return HttpStatus.OK.equals((Object)responseEntity.getStatusCode());
    }

    public Boolean addGold(AccountGoldParam param) {
        ResponseEntity<Boolean> responseEntity = this.userAccountFeignService.addGold(param);
        if (responseEntity.hasBody()) {
            return (Boolean)responseEntity.getBody();
        }
        return false;
    }

    public boolean deductGoldWithLottery(Long userId, Integer goldNum, Long phaseId, String lotteryTitle) {
        AccountGoldParam param = new AccountGoldParam();
        param.setUserId(userId);
        param.setGold(goldNum);
        param.setGoldType(GoldEnum.CONSUME_GOLD.name());
        param.setGoldFlowType(GoldFlowTypeEnum.OTHER.name());
        param.setAddTotal(false);
        param.setRelationId(phaseId);
        param.setReason("\u53c2\u4e0e\u300a" + lotteryTitle + "\u300b");
        param.setContent("\u53c2\u4e0e\u300a" + lotteryTitle + "\u300b");
        return this.addGold(param);
    }
}

