/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.integration;

import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.facade.UserFeignService;
import com.bxm.localnews.merchant.param.UserFollowTypeParam;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UserIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(UserIntegrationService.class);
    @Resource
    private UserFeignService userFeignService;

    public UserInfoDTO getUserFromRedisDB(Long userId) {
        try {
            ResponseEntity<UserInfoDTO> response = this.userFeignService.getUserFromCache(userId);
            if (Objects.nonNull(response) && response.hasBody()) {
                return (UserInfoDTO)response.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u7528\u6237\u670d\u52a1\u5931\u8d25userId: {}", (Object)userId, (Object)e);
        }
        UserInfoDTO userInfoDTO = new UserInfoDTO();
        userInfoDTO.setId(userId);
        return userInfoDTO;
    }

    public void follow(Long formUserId, Long toUserId) {
        if (Objects.isNull(formUserId) || Objects.isNull(toUserId)) {
            log.warn("\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u8fdb\u884c\u5173\u6ce8, formUserId: {} toUserId: {} ", (Object)formUserId, (Object)toUserId);
            return;
        }
        UserFollowTypeParam param = new UserFollowTypeParam();
        param.setFromUserId(formUserId);
        param.setToUserId(toUserId);
        param.setType((byte)0);
        try {
            this.userFeignService.follow(param);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u7528\u6237\u670d\u52a1\u5931\u8d25, formUserId: {} toUserId: {} ", new Object[]{formUserId, toUserId, e});
        }
    }

    public Boolean isFollow(Long formUserId, Long toUserId) {
        if (Objects.isNull(formUserId) || Objects.isNull(toUserId)) {
            log.warn("\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u5173\u6ce8, formUserId: {} toUserId: {} ", (Object)formUserId, (Object)toUserId);
            return false;
        }
        try {
            ResponseEntity<Boolean> responseEntity = this.userFeignService.isFollow(formUserId, toUserId);
            if (Objects.nonNull(responseEntity) && responseEntity.hasBody()) {
                return (Boolean)responseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u7528\u6237\u670d\u52a1\u5931\u8d25, formUserId: {} toUserId: {} ", new Object[]{formUserId, toUserId, e});
        }
        return false;
    }

    public List<UserInfoDTO> getVirtualUserList(Integer num) {
        ResponseEntity<List<UserInfoDTO>> responseEntity = this.userFeignService.getVirtualUserList(num);
        if (responseEntity.hasBody()) {
            return (List)responseEntity.getBody();
        }
        return Lists.newArrayList();
    }

    public Boolean isVip(Long userId) {
        ResponseEntity<Boolean> responseEntity = this.userFeignService.checkUserIsVip(userId);
        if (responseEntity.hasBody()) {
            return (Boolean)responseEntity.getBody();
        }
        return false;
    }

    public Boolean updateUserJudgeMarker(Long userId, LocalNewsUserJudgeMarkerEnum judgeMarker, boolean add) {
        if (log.isDebugEnabled()) {
            log.debug("userId: {} \u66f4\u65b0\u6807\u5fd7\u4f4djudgeMarker: {} ", (Object)userId, (Object)judgeMarker);
        }
        try {
            ResponseEntity<Boolean> responseEntity = this.userFeignService.updateUserJudgeMarker(userId, judgeMarker, add);
            if (Objects.nonNull(responseEntity)) {
                return (Boolean)responseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6807\u5fd7\u4f4d\u5931\u8d25 userId: {} judgeMarker: {}", new Object[]{userId, judgeMarker, e});
        }
        return false;
    }
}

