package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.dto.goods.GoodLotteryManageDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsSampleListDTO;
import com.bxm.localnews.merchant.dto.goods.MerchantAllGoodsDTO;
import com.bxm.localnews.merchant.dto.goods.QueryGoodsManageDTO;
import com.bxm.localnews.merchant.param.GoodsIdManageParamFail;
import com.bxm.localnews.merchant.param.goods.*;
import com.bxm.localnews.merchant.service.goods.GoodsManageService;
import com.bxm.localnews.merchant.vo.goods.GoodsListVo;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 后台商品相关API
 *
 * @author zhoujincheng
 * @date 2020-08-21 09:36
 */
@Api(tags = "11-54  后台商品相关API")
@RestController
@RequestMapping("/manage/merchant/goods/")
public class GoodsManageController {

    @Autowired
    private GoodsManageService goodsManageService;

    @GetMapping("/goodsList")
    @ApiOperation(value = "11-54-1  商品列表", notes = "商品列表", httpMethod = "GET")
    public ResponseJson<PageWarper<GoodsListVo>> getGoodsList(ManageGoodsListParam manageGoodsListParam) {
        return ResponseJson.ok(goodsManageService.getMerchantList(manageGoodsListParam));
    }

    @ApiOperation(value = "11-54-2 审核通过", notes = "审核通过", httpMethod = "POST")
    @PostMapping("/auditSuccess")
    public ResponseJson<Boolean> auditSuccess(@RequestBody @Validated GoodsIdManageParam goodsIdManageParam) {
        Message message = goodsManageService.auditSuccess(goodsIdManageParam);
        if (message.isSuccess()) {
            ResponseJson.ok(message.getLastMessage());
        }
        return ResponseJson.build(message);
    }

    @ApiOperation(value = "11-54-3 审核拒绝", notes = "审核拒绝", httpMethod = "POST")
    @PostMapping("/auditFail")
    public ResponseJson<Boolean> auditFail(@RequestBody @Validated GoodsIdManageParamFail goodsIdManageParamFail) {
        Message message = goodsManageService.auditFail(goodsIdManageParamFail);
        if (message.isSuccess()) {
            ResponseJson.ok(message.getLastMessage());
        }
        return ResponseJson.build(message);
    }

    @ApiOperation(value = "11-54-4 查看商品详情", notes = "查看商品详情", httpMethod = "GET")
    @GetMapping("/queryGoods")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "goodsId", value = "商品id", required = true),
    })
    public ResponseJson<QueryGoodsManageDTO> queryGoods(@RequestParam("goodsId") Long goodsId) {
        Message message = goodsManageService.queryGoods(goodsId);
        if (message.isSuccess()) {
            return ResponseJson.ok(message.getParam("queryGoodsManageDTO"));
        }
        return ResponseJson.build(message);
    }

    @ApiOperation(value = "11-54-5 修改商品", notes = "修改商品", httpMethod = "POST")
    @PostMapping("/update")
    public ResponseJson<Boolean> update(@RequestBody @Validated GoodsUpdateManageParam goodsUpdateManageParam) {
        Message message = goodsManageService.update(goodsUpdateManageParam);
        if (message.isSuccess()) {
            ResponseJson.ok(message.getLastMessage());
        }
        return ResponseJson.build(message);
    }

    @GetMapping("/goodsSampleList")
    @ApiOperation(value = "11-54-6  示例商品列表", notes = "示例商品列表", httpMethod = "GET")
    public ResponseJson<PageWarper<GoodsSampleListDTO>> getGoodsSampleList(@Validated GoodsSampleListParam goodsSampleListParam) {
        return ResponseJson.ok(goodsManageService.getGoodsSampleList(goodsSampleListParam));
    }

    @ApiOperation(value = "11-54-7 修改示例商品", notes = "修改商品", httpMethod = "POST")
    @PostMapping("/updateGoodsSample")
    public ResponseJson<Boolean> updateGoodsSample(@RequestBody @Validated updateGoodsSampleParam updateGoodsSampleParam) {
        Message message = goodsManageService.updateGoodsSample(updateGoodsSampleParam);
        if (message.isSuccess()) {
            ResponseJson.ok(message.getLastMessage());
        }
        return ResponseJson.build(message);
    }

    @ApiOperation(value = "11-54-8 新增商品", notes = "新增商品", httpMethod = "POST")
    @PostMapping("/create")
    public ResponseJson<Boolean> createManger(@RequestBody @Validated GoodsCreateParam goodsCreateParam) {
        Message message = goodsManageService.create(goodsCreateParam);
        if (message.isSuccess()) {
            ResponseJson.ok(message.getLastMessage());
        }
        return ResponseJson.build(message);
    }

    @ApiOperation(value = "11-54-9 新增商品海报并上下架", notes = "新增商品海报并上下架", httpMethod = "POST", nickname = "耿杨杨")
    @PostMapping("/saveOrUpdateGoodsPoster")
    public ResponseJson<Message> saveOrUpdateGoodsPoster(@RequestBody @Validated GoodsPosterParam goodsCreateParam) {
        Message message = goodsManageService.saveOrUpdateGoodsPoster(goodsCreateParam);
        return ResponseJson.ok(message);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "name", value = "商品名称", required = true),
    })
    @GetMapping("/matchGoodsByName")
    @ApiOperation(value = "11-54-10 模糊匹配商品通过商品名称(返回所有商品包含已下架)【夺宝添加奖品用】")
    public ResponseJson<List<GoodLotteryManageDTO>> matchGoodsByName(@Param("name") String name) {
        List<GoodLotteryManageDTO> goodsList = goodsManageService.matchGoodsByName(name);
        return ResponseJson.ok(goodsList);
    }

    @ApiOperation(value = "11-54-11 获取商户所属所有上架商品信息", nickname = "耿杨杨")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "merchantId", value = "商户id", required = true),
            @ApiImplicitParam(name = "type", value = "商品类型，非必填，不传则返回普通商品，0：普通商品， 1：5折会员日商品（详情页面展示不同）， 2：优惠团购商品")
    })

    @GetMapping("allGoods")
    public ResponseJson<List<MerchantAllGoodsDTO>> allGoods(@RequestParam("merchantId") Long merchantId,
                                                            @RequestParam(value = "type", required = false) Integer type) {
        List<MerchantAllGoodsDTO> merchantAllGoodsDTOList = goodsManageService.allGoods(merchantId, type);

        return ResponseJson.ok(merchantAllGoodsDTOList);
    }
}