package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsCreateParam;
import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsManageQueryParam;
import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsOfflineParam;
import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsUpdateParam;
import com.bxm.localnews.merchant.service.goods.MemberDayGoodsManageService;
import com.bxm.localnews.merchant.vo.goods.activity.MemberDayGoodsSubTypeVO;
import com.bxm.localnews.merchant.vo.goods.manage.MemberDayGoodsDetailVO;
import com.bxm.localnews.merchant.vo.goods.manage.MemberDayGoodsManageVO;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/11/19 6:17 下午
 */
@Api(tags = "11-60  5折会员日商品相关API")
@RestController
@RequestMapping("/manage/merchant/memberDay/goods/")
public class MemberDayGoodsManageController {

    @Resource
    private MemberDayGoodsManageService memberDayGoodsManageService;

    @GetMapping("/list")
    @ApiOperation(value = "11-60-1  5折会员日商品列表", notes = "5折会员日商品列表", httpMethod = "GET")
    public ResponseJson<PageWarper<MemberDayGoodsManageVO>> getMemberDayGoodsList(MemberDayGoodsManageQueryParam queryParam) {
        return ResponseJson.ok(memberDayGoodsManageService.getMemberDayGoodsList(queryParam));
    }

    @ApiOperation(value = "11-60-2 查看5折会员日商品详情", notes = "查看5折会员日商品详情", httpMethod = "GET")
    @GetMapping("/detail")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "goodsId", value = "商品id", required = true),
    })
    public ResponseJson<MemberDayGoodsDetailVO> queryGoods(@RequestParam("goodsId") Long goodsId) {
        return ResponseJson.ok(memberDayGoodsManageService.queryGoods(goodsId));

    }

    @ApiOperation(value = "11-60-3 新增5折会员日商品", notes = "新增5折会员日商品", httpMethod = "POST")
    @PostMapping("/create")
    public ResponseJson<Boolean> create(@RequestBody @Validated MemberDayGoodsCreateParam goodsCreateParam) {
        Message message = memberDayGoodsManageService.create(goodsCreateParam);
        if (message.isSuccess()) {
            return ResponseJson.ok(true);
        }
        return ResponseJson.badReqeuset(message.getLastMessage()).build();
    }

    @ApiOperation(value = "11-60-4 修改5折会员日商品", notes = "修改5折会员日商品", httpMethod = "POST")
    @PostMapping("/update")
    public ResponseJson<Boolean> update(@RequestBody @Validated MemberDayGoodsUpdateParam goodsUpdateManageParam) {
        Message message = memberDayGoodsManageService.update(goodsUpdateManageParam);
        if (message.isSuccess()) {
            return ResponseJson.ok(true);
        }
        return ResponseJson.badReqeuset(message.getLastMessage()).build();
    }

    @ApiOperation(value = "11-60-5 上下架5折会员日商品", notes = "上下架5折会员日商品", httpMethod = "POST")
    @PostMapping("/offline")
    public ResponseJson<Message> offline(@RequestBody @Validated MemberDayGoodsOfflineParam param) {
        return ResponseJson.ok(memberDayGoodsManageService.offline(param));
    }

    @ApiOperation(value = "11-60-6 获取五折会员日所有商品类型", notes = "获取五折会员日所有商品类型", httpMethod = "GET")
    @GetMapping("/getSubType")
    public ResponseJson<List<MemberDayGoodsSubTypeVO>> getSubType() {
        return ResponseJson.ok(memberDayGoodsManageService.getSubType());
    }
}