/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.manage.controller;

import com.bxm.component.office.excel.export.impl.SimpleExcelExporter;
import com.bxm.component.office.excel.export.setting.ExcelSheet;
import com.bxm.component.office.excel.export.setting.ExportSetting;
import com.bxm.component.office.excel.export.setting.SheetHeader;
import com.bxm.component.office.excel.parse.impl.SimpleExcelParser;
import com.bxm.component.office.excel.parse.setting.ParseHeader;
import com.bxm.component.office.excel.parse.setting.ParseSetting;
import com.bxm.localnews.merchant.dto.ImportResultDTO;
import com.bxm.localnews.merchant.dto.MerchantManageOrderInfoDTO;
import com.bxm.localnews.merchant.dto.MerchantManageOrderInfoExcel;
import com.bxm.localnews.merchant.param.*;
import com.bxm.localnews.merchant.service.order.MerchantOrderInfoService;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

import static com.bxm.newidea.component.tools.DateUtils.DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL;
import static org.apache.commons.lang3.StringUtils.*;

/**
 * @author jieliGG
 * @date 2020/9/1 17:24
 **/
@Slf4j
@Api(tags = "11-13 管理后台商户订单管理")
@RestController
@AllArgsConstructor
@RequestMapping("manage/merchant/order")
public class MerchantManageOrderController extends BaseController {

    private final MerchantOrderInfoService merchantOrderInfoService;

    @ApiOperation(value = "11-13-01 [v1]管理后台 - 获取订单列表")
    @GetMapping("/getManageOrderList")
    public ResponseJson<PageWarper<MerchantManageOrderInfoDTO>> getList(MerchantManageOrderParam param) {
        return ResponseJson.ok(merchantOrderInfoService.getManagePageListOrder(param));
    }

    @ApiOperation(value = "11-13-02 核销订单")
    @PostMapping("verify")
    public ResponseJson verify(@RequestBody @Valid ManageVerifyOrderParam param,
                               @RequestParam(value = "currentUserId", required = false) Long currentUserId ) {
        if (Objects.nonNull(currentUserId)) {
            param.setCurrentUserId(currentUserId);
        }
        return ResponseJson.build(merchantOrderInfoService.verify(param));
    }

    @ApiOperation(value = "11-13-03 订单导出")
    @GetMapping("orderListExport")
    public ResponseJson orderListExport(MerchantManageOrderParam param, HttpServletResponse response) throws IOException {

        List<MerchantManageOrderInfoExcel> orders = merchantOrderInfoService.orderListExport(param);

        if (CollectionUtils.isEmpty(orders)) {
            return ResponseJson.badReqeuset("无数据").build();
        }

        SimpleExcelExporter excelExporter = SpringContextHolder.getBean(SimpleExcelExporter.class);

        ExportSetting setting = new ExportSetting();
        ExcelSheet excelSheet = setting.addSheet();
        excelSheet.setDataCollection(orders);
        excelSheet.setFreezeHeader(true);
        excelSheet.setSheetName("订单列表");
        excelSheet.setDefaultWidth(30);

        excelSheet.addHeader(new SheetHeader(("订单号"), "orderNo"));
        excelSheet.addHeader(new SheetHeader(("父订单号"), "orderParentNo"));
        excelSheet.addHeader(new SheetHeader(("商品名称"), "goodsName"));
        excelSheet.addHeader(new SheetHeader(("下单时间"), "dateTime"));
        excelSheet.addHeader(new SheetHeader(("付款时间"), "payTime"));
        excelSheet.addHeader(new SheetHeader(("订单金额"), "orderMoney"));
        excelSheet.addHeader(new SheetHeader(("数量"), "num"));
        excelSheet.addHeader(new SheetHeader(("客户姓名"), "userName"));
        excelSheet.addHeader(new SheetHeader(("手机号码"), "userPhone"));
        excelSheet.addHeader(new SheetHeader(("身份证号"), "idNum"));
        excelSheet.addHeader(new SheetHeader(("订单状态"), "state"));
        excelSheet.addHeader(new SheetHeader(("店铺名称"), "merchantName"));
        excelSheet.addHeader(new SheetHeader(("物流状态"), "expressStatus"));
        excelSheet.addHeader(new SheetHeader(("收货详细地址"), "address"));
        excelSheet.addHeader(new SheetHeader(("物流编码"), "expressNum"));
        excelSheet.addHeader(new SheetHeader(("物流公司"), "expressCompany"));

        processDownload(DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL.get().format(new Date()) + "订单批量导出.xls", response);
        excelExporter.export(response.getOutputStream(), setting);

        return ResponseJson.build();
    }

    @ApiOperation(value = "11-13-04 订单导入")
    @ApiImplicitParam(name = "excelFile", value = "导入的Excel文件 包含列名为（订单编号 物流编码 物流公司）")
    @PostMapping("orderListImport")
    public ResponseJson<List<ImportResultDTO>> orderListImport(@RequestParam("excelFile") MultipartFile excelFile, @RequestParam("currentUserId") Long currentUserId) {
        if (null == excelFile || Objects.isNull(excelFile.getOriginalFilename())) {
            return ResponseJson.badReqeuset("请求参数未发现参数名为[excelFile]的文件流").build();
        }

        if (!excelFile.getOriginalFilename().endsWith(".xls")) {
            return ResponseJson.badReqeuset("请上传.xls文件").build();
        }

        SimpleExcelParser<OrderListImportParam> parser = SpringContextHolder.getBean(SimpleExcelParser.class);
        ParseSetting setting = new ParseSetting()
                .setEntityClasz(OrderListImportParam.class)
                .setHeaderModel(true);

        setting.addHead(new ParseHeader("订单编号", "orderNo"));
        setting.addHead(new ParseHeader("物流编码", "expressNum"));
        setting.addHead(new ParseHeader("物流公司", "expressCompany"));

        try {
            List<ImportResultDTO> responseRes = Lists.newArrayList();

            List<OrderListImportParam> result = parser.parse(excelFile.getInputStream(), setting);

            AtomicInteger i = new AtomicInteger(1);
            result.forEach(p -> {
                if (isBlank(p.getExpressCompany()) || isBlank(p.getExpressNum()) || isBlank(p.getOrderNo())) {
                    return;
                }

                p.setCurrentUserId(currentUserId);
                Message message = merchantOrderInfoService.deliverOrder(p);

                ImportResultDTO resultDTO = new ImportResultDTO();
                resultDTO.setRowNum(i.getAndIncrement());
                resultDTO.setTitle(p.getOrderNo());
                resultDTO.setResult(message.getLastMessage());
                resultDTO.setSuccess(message.isSuccess());


                responseRes.add(resultDTO);

            });

            return ResponseJson.ok(responseRes);

        } catch (Exception e) {
            log.error("操作excel失败", e);
        }

        return ResponseJson.badReqeuset("请求失败").build();
    }

    @ApiOperation(value = "11-13-01 管理后台操作退款")
    @PostMapping("refundOperator")
    public ResponseJson refundOperator(@RequestBody RefundOperatorParam param) {
        MerchantOperatorOrderParam merchantOperatorOrderParam = new MerchantOperatorOrderParam();
        merchantOperatorOrderParam.setOrderNo(param.getOrderNo());
        merchantOperatorOrderParam.setState(param.getState());
        merchantOperatorOrderParam.setCurrentUserId(param.getCurrentUserId());

        return ResponseJson.build(merchantOrderInfoService.refundOperator(merchantOperatorOrderParam));
    }
}
