package com.bxm.localnews.merchant.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author gonzo
 * @date 2020-09-01 20:47
 **/
@Data
@ApiModel("提现详情")
public class H5WithdrawDetail {

    @ApiModelProperty("提现id")
    private Long withdrawId;

    @ApiModelProperty("提现时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date withdrawTime;

    @ApiModelProperty("提现账号 如果是支付宝提现 则是支付宝账号")
    private String account;

    @ApiModelProperty(value = "提现渠道,1:微信提现，2：支付宝提现")
    private Byte payChannel;

    @ApiModelProperty("提现结果  1-成功 0-失败 2-提现中")
    private Integer status;

    @ApiModelProperty("提现金额")
    private BigDecimal withdrawMoney;

    @ApiModelProperty("提现人信息")
    private String realName;

    @ApiModelProperty("提现单号")
    private String orderNo;

}
