package com.bxm.localnews.merchant.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "后台查询认证信息出参")
@Data
public class MerchantAuthInfoDto{

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty(value = "关联商家id")
    private Long merchantId;

    @ApiModelProperty("店铺名称")
    private String merchantName;

    @ApiModelProperty("商户行业分类id")
    private Long categoryId;

    @ApiModelProperty("0有营业执照1无营业执照")
    private Integer type;

    @ApiModelProperty("营业执照图片地址")
    private String licensePic;

    @ApiModelProperty("法人身份证正面照片")
    private String legalPersonFacePic;

    @ApiModelProperty("法人身份证反面照片")
    private String legalPersonBackPic;

    @ApiModelProperty("认证状态 0: 未提交、待认证 1: 已提待审核 2: 审核通过 3: 审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("备注")
    private String remark;

}
