/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jieliGG
 * @date 2020/8/20 17:31
 * 商户订单列表
 **/
@Builder
@Data
public class MerchantOrderInfoDTO {

    @ApiModelProperty("商品id")
    private Long goodsId;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("商品图片")
    private String goodsImg;

    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date dateTime;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("订单金额")
    private BigDecimal orderMoney;

    @ApiModelProperty("用户实际支付金额")
    private BigDecimal userPayMoney;

    @ApiModelProperty("现金红包金额")
    private BigDecimal coupon;

    @ApiModelProperty("商品优惠券文案描述")
    private String couponDesc;

    @ApiModelProperty("数量")
    private Long num;

    @ApiModelProperty("客户姓名")
    private String userName;

    @ApiModelProperty("手机号码")
    private String userPhone;

    @ApiModelProperty("订单状态【0-待核销 1-待付款 2-售后退款 3-已核销 4-已取消订单 5-拒绝退款 6-同意退款】")
    private Integer state;

    @ApiModelProperty("state=2时，申请退款后的时间倒计时 剩余的秒数【226800】秒")
    private Long leftTime;
}
