/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jieliGG
 * @date 2020/8/24 11:38
 * 商家去提现返回的参数
 **/
@Data
@Builder
public class MerchantToWithdrawDTO {

    @ApiModelProperty("是否提现成功")
    private Boolean success;

    @ApiModelProperty("提现错误信息")
    private String errorMsg;

    @ApiModelProperty("提现的金额 : 元")
    private BigDecimal withdrawMoney;

    @ApiModelProperty("提现账号 如果是支付宝提现 则是支付宝账号")
    private String account;

    @ApiModelProperty(value = "提现渠道,1:微信提现，2：支付宝提现")
    private Byte payChannel;

    @ApiModelProperty("提现时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date withdrawTime;

    @ApiModelProperty("支付订单号")
    private String orderNo;

    @ApiModelProperty("提现id")
    private Long withdrawId;

    @Tolerate
    public MerchantToWithdrawDTO() {

    }
}
