package com.bxm.localnews.merchant.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(description = "返回商家推广金账户信息出参")
public class MerchantUserPromotionAccountDto {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("总推广金")
    private BigDecimal totalPromotionCash;


    @ApiModelProperty("可用推广金")
    private BigDecimal ablePromotionCash;
    @ApiModelProperty("冻结中推广金")
    private BigDecimal freezePromotionCash;
    @ApiModelProperty("'已消费推广金金额")
    private BigDecimal consumePromotionCash;

    @ApiModelProperty("变更版本")
    private Integer version;

    @ApiModelProperty("创建时间，也就是商家申请入驻时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date modifyTime;


}
