/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.dto.account;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jieliGG
 * @date 2020/8/24 15:47
 * 商家订单详情
 **/
@Data
public class MerchantOrderDetailDTO {
    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("是否是vip购买的:0-不是 1-是")
    private Integer vip;

    @ApiModelProperty("账单金额")
    private BigDecimal money;

    @ApiModelProperty("账单id：查看订单详情使用")
    private Long orderId;

    @ApiModelProperty("交易人")
    private String userName;

    @ApiModelProperty("手机号码")
    private String phone;

    @ApiModelProperty("支付单号")
    private String payOrderNo;

    @ApiModelProperty("交易时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date transTime;

    @ApiModelProperty("流水类型 0:收入  1:手续费  2:提现成功金额  3:提现失败返还金额 4:分销  5:提现中 6:退单 9:平台补贴")
    private Integer status;

    @ApiModelProperty("退单类型：1-手动退款 2-超时退单")
    private Integer refundType;

    @ApiModelProperty("退单结果 ： 0-失败 1-成功")
    private Integer refundStatus;

    @ApiModelProperty("是否入账0-未入账 1-已入账")
    private Integer receive;
}
