package com.bxm.localnews.merchant.dto.coupon;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

import static com.bxm.localnews.merchant.common.constant.AppCommonStatus.COMMON_DATE_FORMAT;

/**
 * @author liujia
 * @date 2020-09-21 18:43
 **/
@Data
public class BaseCouponInfoDTO {
    @ApiModelProperty("优惠券ID")
    private Long couponId;

    @ApiModelProperty("优惠券可用时间-起始时间(已格式化)")
    @JsonFormat(pattern = COMMON_DATE_FORMAT)
    private Date usableStartTime;

    @ApiModelProperty("优惠券可用时间-截止时间(已格式化)")
    @JsonFormat(pattern = COMMON_DATE_FORMAT)
    private Date usableEndTime;

    @ApiModelProperty("领取的门槛金额（最少消费金额）")
    private BigDecimal totalAmount;

    @ApiModelProperty("优惠券的减免金额")
    private BigDecimal discount;
}
