package com.bxm.localnews.merchant.dto.coupon;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

import static com.bxm.localnews.merchant.common.constant.AppCommonStatus.COMMON_DATE_FORMAT;

/**
 * @author liujia
 * @date 2020-09-21 18:14
 **/
@ApiModel(description = "优惠券每日详情项目信息")
@Data
@Builder
public class MerchantCouponReportItemDTO {

    @Tolerate
    public MerchantCouponReportItemDTO() {
    }

    @ApiModelProperty("统计日期(已格式化)")
    @JsonFormat(pattern = COMMON_DATE_FORMAT)
    private Date statisticsDate;

    @ApiModelProperty("相关数量")
    private Integer quantity;

    @ApiModelProperty("相关人数")
    private Integer userQuantity;
}
