package com.bxm.localnews.merchant.dto.coupon;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

import static com.bxm.localnews.merchant.common.constant.AppCommonStatus.COMMON_DATE_DETAIL_FORMAT;

/**
 * @author liujia
 * @date 2020-09-21 19:47
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "用户优惠券详情")
public class UserCouponDetailDTO extends BaseCouponInfoDTO {

    @ApiModelProperty("优惠券所属商户ID")
    private Long merchantId;

    @ApiModelProperty("优惠券所属商户名称")
    private String merchantName;

    @ApiModelProperty("优惠券所属商户头图")
    private String merchantMasterPicture;

    @ApiModelProperty("优惠券所属商户地址")
    private String merchantAddress;

    @ApiModelProperty("优惠券的使用规则")
    private String ruleRemark;

    @ApiModelProperty("用户优惠券状态，1：未使用，2：已使用，3：待核销确认（同已使用），97：已过期，98：已停用,99：已作废（不同于优惠券状态）")
    private Integer userCouponStatus;

    @ApiModelProperty("优惠券类型，0：商家优惠券，1：现金抵扣券（可下单抵用）")
    private Integer type;

    @ApiModelProperty("核销时间，如果存在则显示核销时间(已格式化)")
    @JsonFormat(pattern = COMMON_DATE_DETAIL_FORMAT)
    private Date chargeOffTime;

    @ApiModelProperty("抵用的订单标题，如果存在此字段则显示订单信息")
    private String orderTitle;

    @ApiModelProperty(value = "用户领取的消费券ID", required = true)
    private Long userCouponId;

    @ApiModelProperty("是否有金额门槛（1：有，0：无）")
    private Integer conditionAmount;
}
