package com.bxm.localnews.merchant.dto.goods;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zhoujincheng
 * @create: 2020-08-21 13:54
 */
@Data
public class CollectionListDTO {
    @ApiModelProperty("商品展示图")
    private String headPics;

    @ApiModelProperty("原价")
    private BigDecimal originalPrice;

    @ApiModelProperty("现价")
    private BigDecimal price;

    @ApiModelProperty("商品名称")
    private String name;

    @ApiModelProperty("商品状态0下架1上架")
    private Integer shelfType;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;


    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;

    @ApiModelProperty("商品id")
    private Long goodsId;

    @ApiModelProperty("收藏时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date collectTime;

}
