package com.bxm.localnews.merchant.dto.goods;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(description = "商家基本信息出参")
@Data
public class MerchantDto {

    @ApiModelProperty("商家id")
    private Long merchantId;

    @ApiModelProperty("店铺头图的json数组字符串")
    private String headPics;

    @ApiModelProperty("商家名称")
    private String merchantName;


    @ApiModelProperty("地址信息")
    private String address;

    @ApiModelProperty("经度")
    private BigDecimal lat;

    @ApiModelProperty("维度")
    private BigDecimal lng;

}
