package com.bxm.localnews.merchant.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * t_merchant_cash_flow
 *
 * @author
 */
public class MerchantCashFlowEntity implements Serializable {
    private Long id;

    /**
     * 商家id
     */
    private Long merchantId;

    /**
     * 流水金额
     */
    private BigDecimal amount;

    /**
     * 实际到账金额 （当流水类型为CASH_PAYMENT时使用，方便区分该笔流水支付和实际入账金额）
     */
    private BigDecimal receiveAmount;

    /**
     * 流水类型
     */
    private String type;

    /**
     * 备注
     */
    private String remark;

    /**
     * 关联的业务id
     */
    private Long relationId;

    /**
     * 关联的业务名称
     */
    private String relationTitle;

    private Date createTime;

    private String goodsName;

    /**
     * 0 : 未出账  1：已出账  区分核销前和核销后   提现中 和提现完成
     */
    private Integer cashFlag;

    public BigDecimal getReceiveAmount() {
        return receiveAmount;
    }

    public void setReceiveAmount(BigDecimal receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public Integer getCashFlag() {
        return cashFlag;
    }

    public void setCashFlag(Integer cashFlag) {
        this.cashFlag = cashFlag;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRelationTitle() {
        return relationTitle;
    }

    public void setRelationTitle(String relationTitle) {
        this.relationTitle = relationTitle;
    }
}