package com.bxm.localnews.merchant.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * t_merchant_content_record
 * @author 
 */
public class MerchantContentRecordEntity implements Serializable {
    private Long id;

    private Long relationId;

    /**
     * 业务id，如帖子，新闻等。[TOPIC,FORUM]
     */
    private String relationType;

    /**
     * 分享的内容标题
     */
    private String relationTitle;

    /**
     * 阅读数
     */
    private Long viewAmount;

    /**
     * 分享总数
     */
    private Long shareAmount;

    /**
     * 提供线索数/点击广告数
     */
    private Long clickAmount;

    /**
     * 商户id
     */
    private Long merchantId;

    /**
     * 所属受益人id，徒弟或师傅分享，都为师傅id
     */
    private Long belonger;

    /**
     * 分享人，可以为徒弟，师傅或者商家
     */
    private Long operator;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最终分享所属人昵称
     */
    private String belongerName;

    /**
     * 最终分享所属人头像
     */
    private String belongerHeadImg;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getRelationTitle() {
        return relationTitle;
    }

    public void setRelationTitle(String relationTitle) {
        this.relationTitle = relationTitle;
    }

    public Long getViewAmount() {
        return viewAmount;
    }

    public void setViewAmount(Long viewAmount) {
        this.viewAmount = viewAmount;
    }

    public Long getShareAmount() {
        return shareAmount;
    }

    public void setShareAmount(Long shareAmount) {
        this.shareAmount = shareAmount;
    }

    public Long getClickAmount() {
        return clickAmount;
    }

    public void setClickAmount(Long clickAmount) {
        this.clickAmount = clickAmount;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public Long getBelonger() {
        return belonger;
    }

    public void setBelonger(Long belonger) {
        this.belonger = belonger;
    }

    public Long getOperator() {
        return operator;
    }

    public void setOperator(Long operator) {
        this.operator = operator;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getBelongerName() {
        return belongerName;
    }

    public void setBelongerName(String belongerName) {
        this.belongerName = belongerName;
    }

    public String getBelongerHeadImg() {
        return belongerHeadImg;
    }

    public void setBelongerHeadImg(String belongerHeadImg) {
        this.belongerHeadImg = belongerHeadImg;
    }
}