package com.bxm.localnews.merchant.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * t_merchant_exposure_record
 * @author 
 */
public class MerchantExposureRecordEntity implements Serializable {
    private Long id;

    /**
     * 商家id
     */
    private Long merchantId;

    /**
     * 便民页排序 0为未配置
     */
    private Integer bianMinOrder;

    /**
     * 推广状态 0: 不可用 1: 可用
     */
    private Boolean status;

    /**
     * 便民推荐开始时间
     */
    private Date bianMinStartTime;

    /**
     * 便民推荐结束时间
     */
    private Date bianMinEndTime;

    /**
     * 推广页排序 0为未配置
     */
    private Integer channelOrder;

    /**
     * 频道推荐开始时间
     */
    private Date channelStartTime;

    /**
     * 频道推荐结束时间
     */
    private Date channelEndTime;

    /**
     * 频道球区排序 0为未配置
     */
    private Integer channelQuOrder;

    /**
     * 频道球区推荐开始时间
     */
    private Date channelQuStartTime;

    /**
     * 频道球区推荐结束时间
     */
    private Date channelQuEndTime;

    /**
     * 商家对应的区域code 冗余字段，便于查找某一区域下的商家推荐
     */
    private String areaCode;

    private Date createTime;

    private Date modifyTime;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public Integer getBianMinOrder() {
        return bianMinOrder;
    }

    public void setBianMinOrder(Integer bianMinOrder) {
        this.bianMinOrder = bianMinOrder;
    }

    public Boolean getStatus() {
        return status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Date getBianMinStartTime() {
        return bianMinStartTime;
    }

    public void setBianMinStartTime(Date bianMinStartTime) {
        this.bianMinStartTime = bianMinStartTime;
    }

    public Date getBianMinEndTime() {
        return bianMinEndTime;
    }

    public void setBianMinEndTime(Date bianMinEndTime) {
        this.bianMinEndTime = bianMinEndTime;
    }

    public Integer getChannelOrder() {
        return channelOrder;
    }

    public void setChannelOrder(Integer channelOrder) {
        this.channelOrder = channelOrder;
    }

    public Date getChannelStartTime() {
        return channelStartTime;
    }

    public void setChannelStartTime(Date channelStartTime) {
        this.channelStartTime = channelStartTime;
    }

    public Date getChannelEndTime() {
        return channelEndTime;
    }

    public void setChannelEndTime(Date channelEndTime) {
        this.channelEndTime = channelEndTime;
    }

    public Integer getChannelQuOrder() {
        return channelQuOrder;
    }

    public void setChannelQuOrder(Integer channelQuOrder) {
        this.channelQuOrder = channelQuOrder;
    }

    public Date getChannelQuStartTime() {
        return channelQuStartTime;
    }

    public void setChannelQuStartTime(Date channelQuStartTime) {
        this.channelQuStartTime = channelQuStartTime;
    }

    public Date getChannelQuEndTime() {
        return channelQuEndTime;
    }

    public void setChannelQuEndTime(Date channelQuEndTime) {
        this.channelQuEndTime = channelQuEndTime;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }
}