package com.bxm.localnews.merchant.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liujia
 * 商品浏览记录表
 */
@Data
public class MerchantGoodsViewEntity implements Serializable {
    /**
     * 浏览记录ID
     */
    private Long id;

    /**
     * 商品ID
     */
    private Long goodsId;

    /**
     * 浏览人ID
     */
    private Long userId;

    /**
     * 浏览人昵称
     */
    private String nickName;

    /**
     * 浏览人头像
     */
    private String headImg;

    /**
     * 浏览来源（站内、站外）
     */
    private Byte source;

    /**
     * 浏览时间
     */
    private Date createTime;

    private static final long serialVersionUID = 1L;
}