package com.bxm.localnews.merchant.entity.coupon;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.util.Date;

/**
 * @author
 */
@Data
@Builder
public class MerchantCouponReceiveRecordEntity implements Serializable {

    @Tolerate
    public MerchantCouponReceiveRecordEntity() {
    }

    /**
     * 主键
     */
    private Long id;

    /**
     * 优惠卷ID
     */
    private Long couponMasterId;

    /**
     * 优惠卷镜像ID，用于查找显示的信息
     */
    private Long couponMirrorId;

    /**
     * 核销码
     */
    private String code;

    /**
     * 领取用户的ID
     */
    private Long userId;

    /**
     * 优惠卷状态
     */
    private Integer status;

    /**
     * 领取时间
     */
    private Date createTime;

    /**
     * 关联使用的订单编号
     */
    private String orderNo;

    /**
     * 关联的订单标题
     */
    private String orderTitle;

    /**
     * 核销时间（使用时间）
     */
    private Date useTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    /**
     * 劵类型（0：商品优惠卷、1：现金抵扣卷）
     */
    private Integer type;

    /**
     * 处理批次ID
     */
    private Long batchId;

    private static final long serialVersionUID = 1L;
}