package com.bxm.localnews.merchant.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author : pf.w
 * @date : 2020-09-25
 */
@Data
@ApiModel(description = "审核信息入参")
public class AuditAuthInfoParam {

    @ApiModelProperty(value = "网关获取当前用户",required = true)
    private Long currentUserId;

    @ApiModelProperty(value = "当前用户",required = true)
    private Long auditUserId;

    @ApiModelProperty(value = "商家id",required = true)
    private Long merchantId;

    @ApiModelProperty(value = "审核主键id",required = true)
    private Long id;

    @ApiModelProperty(value = "备注信息")
    private String remark;

    @ApiModelProperty(value = "认证状态 0: 未提交、待认证 1: 已提待审核 2: 审核通过 3: 审核拒绝",required = true)
    private Integer qualificationStatus;

    @ApiModelProperty(value = "0有营业执照1无营业执照",required = true)
    private Integer type;

    @ApiModelProperty(value = "营业执照照片")
    private String licensePic;

    @ApiModelProperty(value = "法人身份证正面照片")
    private String legalPersonFacePic;

    @ApiModelProperty(value = "法人身份证反面照片")
    private String legalPersonBackPic;

}
