package com.bxm.localnews.merchant.param.account;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author pf.w
 * @date 2020/8/21 9:21
 **/
@ApiModel(description = "收支流水上行参数")
@Data
public class BossCashParam extends PageParam {

    @ApiModelProperty(value = "商家ID", required = true)
    @NotBlank(message = "商家ID不能为空")
    private Long merchantId;

    @ApiModelProperty(value = "流水类型  0：入账  1：冻结", required = true)
    @NotBlank
    private Integer cashType;
}
