package com.bxm.localnews.merchant.param.coupon;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 商家优惠券基础操作参数
 *
 * @author liujia
 * @date 2020-09-21 17:49
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "商家优惠券基础参数")
public class BaseMerchantCouponParam extends BaseBean {
    private static final long serialVersionUID = 4218360658144471698L;
    @ApiModelProperty(value = "当前商户ID", required = true)
    private Long merchantId;

    @ApiModelProperty(value = "当前操作用户ID", required = true)
    private Long userId;

    @ApiModelProperty(value = "商品id", required = true)
    private Long goodsId;

    @ApiModelProperty(value = "商品真实计算金额（使用优惠券前的商品最终金额，但不包含开会员的金额）", required = true)
    private BigDecimal goodsRealPrice;
}
