package com.bxm.localnews.merchant.param.coupon;

import lombok.Data;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 授予用户一张现金优惠券
 * 可用于测试接口和后续的联通接口联调
 *
 * @author liujia
 * @date 2020-09-27 13:48
 **/
@Data
@ToString
public class CashCouponGrantParam {

    /**
     * 接收优惠券的用户
     */
    private Long targetUserId;

    /**
     * 优惠券限制使用的商户
     */
    private Long merchantId;

    /**
     * 优惠券的面额
     */
    private BigDecimal amount;

    /**
     * 优惠券使用门槛
     */
    private BigDecimal maxAmount;

    /**
     * 优惠券的可用起始金额
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date usableStartTime;

    /**
     * 优惠券的可用截止金额
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date usableEndTime;

    /**
     * 优惠券来源，参见：com.bxm.localnews.merchant.coupon.emnus.CouponSourceEnum
     */
    private Integer couponSource;

    /**
     * 是否有门槛
     */
    private Boolean conditionAmount = false;
}
