package com.bxm.localnews.merchant.param.coupon;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liujia
 * @date 2020-09-21 21:23
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "管理后台分页查询优惠券")
@Data
public class ManageCouponQueryParam extends PageParam {

    @ApiModelProperty("优惠券ID")
    private Long couponId;

    @ApiModelProperty("商户手机号码")
    private String merchantPhone;

    @ApiModelProperty("商户名称")
    private String merchantName;

    @ApiModelProperty("优惠券状态，如果为null则表示为查询全部")
    private Integer status;
}
