package com.bxm.localnews.merchant.param.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liujia
 * @date 2020-09-21 17:59
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "商家创建优惠券参数")
@Data
public class MerchantCouponCreateParam extends BaseMerchantCouponParam {

    @ApiModelProperty("是否有金额使用门槛")
    private Boolean conditionAmount;

    @ApiModelProperty("优惠券门槛金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("优惠券优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("库存数量")
    private Integer totalQuantity;

    @ApiModelProperty("单人可领取的最大数量，默认为1")
    private Integer maxNum;

    @ApiModelProperty("是否需要关注")
    private Boolean conditionFollow;

    @ApiModelProperty("优惠券可用起始时间")
    private Date usableStartDate;

    @ApiModelProperty("优惠券可用截止时间")
    private Date usableEndDate;

    @ApiModelProperty("使用规则")
    private String ruleRemark;

    @ApiModelProperty("分享文案")
    private String shareTips;

    @ApiModelProperty(value = "优惠券ID", hidden = true)
    private Long couponId;

    /**
     * 参见：com.bxm.localnews.merchant.coupon.emnus.CouponSourceEnum
     */
    @ApiModelProperty(value = "优惠券的数据来源", hidden = true)
    private Integer source;

    /**
     * 参见：com.bxm.localnews.merchant.coupon.emnus.CouponTypeEnum
     */
    @ApiModelProperty(value = "优惠券类型", hidden = true)
    private Integer type;

    /**
     * 参见：com.bxm.localnews.merchant.coupon.emnus.CouponDisplayLevelEnum
     */
    @ApiModelProperty(value = "展示级别", hidden = true)
    private Integer display;
}
