package com.bxm.localnews.merchant.param.goods;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author: gengyy
 * @create: 2020-10-22 16:54
 */
@Data
@ApiModel(description = "商品海报请求类")
public class GoodsPosterParam {

    @ApiModelProperty(value = "商品id",required = true)
    @NotNull(message = "商品id不能为空")
    private Long goodsId;

    @ApiModelProperty(value = "商品海报url",required = true)
    @NotNull(message = "商品海报url不能为空")
    private String posterUrl;

    @ApiModelProperty(value = "商品海报上架状态 0 下架 1 上架",required = true)
    @NotNull(message = "商品海报上架状态不能为空")
    private Byte posterStatus;

    @ApiModelProperty(value ="商品海报名称",required = true)
    @NotNull(message = "商品海报名称不能为空")
    private String posterName;

}
